/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.validacion.esquema;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidacionXSDErrorHandler
extends DefaultHandler {
    private int errorCount = 0;
    private static final String MIN_INCLUSIVE = "cvc-minInclusive-valid";
    private static final String MAX_INCLUSIVE = "cvc-maxInclusive";
    private static final String COMPLEX_TYPE = "cvc-complex-type";
    private static final String CVC_TYPE = "cvc-type";
    private static final String CVC_DATA_TYPE = "cvc-datatype";
    private static final String CVC_LENGHT = "cvc-length-valid";
    private static final String CVC_MIN_LENGTH = "cvc-minLength-valid";
    private static final String CVC_MAX_LENGHT = "cvc-maxLength-valid";
    private static final String CVC_ENUM = "cvc-enumeration";
    private final StringBuffer buffer = new StringBuffer(1500);

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.printException(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.printException(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.printException(e);
    }

    private void printException(SAXParseException e) {
        boolean estaImpreso = false;
        if (this.errorCount == 100) {
            return;
        }
        if (e.getMessage().contains(CVC_TYPE)) {
            ++this.errorCount;
            this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "   Columna: " + e.getColumnNumber() + "\t" + "   Mensaje: " + ValidacionXSDErrorHandler.convertirMensaje(e.getMessage()) + "\n");
            estaImpreso = true;
        }
        if (e.getMessage().contains(CVC_DATA_TYPE) && !estaImpreso) {
            ++this.errorCount;
            this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "Columna: " + e.getColumnNumber() + "\t" + "Mensaje: " + ValidacionXSDErrorHandler.convertirMensajeTipoDeDato(e.getMessage()) + "\n");
            estaImpreso = true;
        } else if (e.getMessage().contains(COMPLEX_TYPE) && !estaImpreso) {
            ++this.errorCount;
            this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "Columna: " + e.getColumnNumber() + "\t" + "Mensaje: " + this.convertirMensajeContenidoInvalido(e.getMessage()) + "\n");
            estaImpreso = true;
        } else if (!e.getMessage().matches("(cvc-pattern-valid|cvc-minInclusive-valid|cvc-enumeration|cvc-maxInclusive|cvc-length-valid|cvc-minLength-valid|cvc-maxLength-valid).*") && !estaImpreso) {
            ++this.errorCount;
            if (e.getMessage().indexOf("must be terminated by the matching end-tag") != -1 && this.buffer.indexOf("El XML esta mal formado") != -1) {
                this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "   Columna: " + e.getColumnNumber() + "\t" + "   Mensaje: " + "El elemento de esta l\u00ednea no est\u00e1 iniciado" + "\n");
            } else if (e.getMessage().indexOf("must be terminated by the matching end-tag") != -1) {
                this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "   Columna: " + e.getColumnNumber() + "\t" + "  Mensaje: " + ValidacionXSDErrorHandler.convertirMensajeFatal(e.getMessage()) + "\n");
            } else if (e.getMessage().indexOf("root element must be well-formed") != -1 && this.buffer.indexOf("de acuerdo al tipo de anexo seleccionado") != -1) {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "   Columna: " + e.getColumnNumber() + "\t" + "  Mensaje: El archivo debe iniciar con un elemento root" + "\n");
            } else if (e.getMessage().indexOf("cvc-elt.1: Cannot find the declaration ") != -1) {
                this.buffer.append("  Mensaje:  Debe seleccionar un archivo de acuerdo al tipo de anexo seleccionado.\n");
            } else if (e.getMessage().indexOf("XML document structures must start and end within the same entity") != -1) {
                this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "   Columna: " + e.getColumnNumber() + "\t" + "  Mensaje: El archivo debe finalizar con el respectivo elemento root" + "\n");
            } else if (this.buffer.indexOf("Contenido Invalido se encontro") == -1) {
                this.buffer.append("   Linea: " + e.getLineNumber() + "\t" + "   Columna: " + e.getColumnNumber() + "\t" + "   Mensaje: " + e.getMessage() + "\n");
            }
            estaImpreso = true;
        }
    }

    private static String convertirMensaje(String message) {
        try {
            String valor = null;
            String elemento = null;
            Pattern patron = Pattern.compile("\\s'[^']*'\\s");
            String[] arrValores = message.split("\\s'[^']*'\\s");
            Matcher encaja = patron.matcher(message);
            if (encaja.find()) {
                valor = encaja.group(0);
                encaja.find();
                if (arrValores != null && arrValores.length > 2) {
                    elemento = encaja.group(0);
                } else {
                    return "El elemento" + valor + "contiene un valor incorrecto.";
                }
            }
            return "El elemento" + elemento + "contiene un valor incorrecto: " + valor;
        }
        catch (Exception exception) {
            return "El XML esta mal formado::" + message;
        }
    }

    private String convertirMensajeContenidoInvalido(String message) {
        try {
            String valor = null;
            String elemento = null;
            Pattern patron = Pattern.compile("\\s+'(\\W\\w+\\W|\\w+)'(\\s+|.)");
            Matcher encaja = patron.matcher(message);
            if (encaja.find()) {
                valor = encaja.group(0);
                encaja.find();
                elemento = encaja.group(0);
            }
            return "Contenido Invalido se encontro " + valor + " cuando se esperaba " + elemento;
        }
        catch (Exception exception) {
            return "El XML esta mal formado (xml)";
        }
    }

    private static String convertirMensajeFatal(String message) {
        try {
            String valor = null;
            String elemento = null;
            Pattern patron = Pattern.compile(".*(\"\\w+\").*(</\\w+>).*");
            Matcher encaja = patron.matcher(message);
            if (encaja.matches()) {
                valor = encaja.group(1);
                if (encaja.groupCount() > 1) {
                    elemento = encaja.group(2);
                } else {
                    return "El tipo de elemento " + valor + " no est\u00e1 terminado o iniciado.";
                }
            }
            return "El tipo de elemento " + valor + " debe ser terminado con " + elemento + " \u00f3 uno de sus subelementos no est\u00e1 iniciado";
        }
        catch (Exception exception) {
            return "El XML esta mal formado (elementos)";
        }
    }

    private static String convertirMensajeTipoDeDato(String message) {
        try {
            String valor = null;
            String elemento = null;
            Pattern patron = Pattern.compile("('(?:\\w|\\s)+')");
            Matcher encaja = patron.matcher(message);
            while (encaja.find()) {
                if (valor != null) {
                    elemento = encaja.group(1);
                    continue;
                }
                valor = encaja.group(1);
            }
            return String.valueOf(valor) + " no es un valor v\u00e1lido para el tipo de dato " + elemento;
        }
        catch (Exception exception) {
            return "El XML esta mal formado(valores)";
        }
    }

    public String getErrors() {
        return this.buffer.toString();
    }
}

